<?php
require('../panel/user/extension/connect.php');

/**
 * Get header Authorization
 * */
function getAuthorizationHeader()
{
    $headers = null;
    if (isset($_SERVER['Authorization'])) {
        $headers = trim($_SERVER["Authorization"]);
    } else if (isset($_SERVER['HTTP_AUTHORIZATION'])) { //Nginx or fast CGI
        $headers = trim($_SERVER["HTTP_AUTHORIZATION"]);
    } elseif (function_exists('apache_request_headers')) {
        $requestHeaders = apache_request_headers();
        // Server-side fix for bug in old Android versions (a nice side-effect of this fix means we don't care about capitalization for Authorization)
        $requestHeaders = array_combine(array_map('ucwords', array_keys($requestHeaders)), array_values($requestHeaders));
        //print_r($requestHeaders);
        if (isset($requestHeaders['Authorization'])) {
            $headers = trim($requestHeaders['Authorization']);
        }
    }
    return $headers;
}


/**
 * get access token from header
 * */
function getBearerToken()
{
    $headers = getAuthorizationHeader();
    // HEADER: Get the access token from the header
    if (!empty($headers)) {
        if (preg_match('/Bearer\s(\S+)/', $headers, $matches)) {
            return $matches[1];
        }
    }
    return null;
}


/**
 * generate jwt
 * */
function generate_jwt($headers, $payload, $secret = 'secret'){
    $headers_encoded = base64url_encode(json_encode($headers));

    $payload_encoded = base64url_encode(json_encode($payload));

    $signature = hash_hmac('SHA256', "$headers_encoded.$payload_encoded", $secret, true);
    $signature_encoded = base64url_encode($signature);

    return "$headers_encoded.$payload_encoded.$signature_encoded";
}

function base64url_encode($str)
{
    return rtrim(strtr(base64_encode($str), '+/', '-_'), '=');
}

if (isset($_GET['token'])) {
    //Generate a random string.
    $strong_result = true;
    $token = openssl_random_pseudo_bytes(16, $strong_result);

    //Convert the binary data into hexadecimal representation.
    $token = bin2hex($token);

    //Print it out for example purposes.
    echo $token;
}

if (isset($_GET['create'])) {

    if($_GET['create'] === 'credits'){
        $modelId = $_GET['modelId'];
        $modelId = mysqli_real_escape_string($con, $modelId);

        $credits = $_GET['client_balance'];
        $credits = mysqli_real_escape_string($con, $credits);

        $sql = "UPDATE `users` SET `user_credits` = `user_credits` + $credits WHERE `model_id` = $modelId";

        $result = mysqli_query($con, $sql);
        if ($result) {
            echo "success";
            http_response_code(200);
        } else {
            http_response_code(422);
        }


    } else if ($_GET['create'] === 'reseller') {
        $date = date("Y-m-d h:i:s");
        $username = $_GET['username'];
        $username = mysqli_real_escape_string($con, $username);

        $password = $_GET['password'];
        $password = mysqli_real_escape_string($con, $password);
        $auth_pass = md5($password);

        $modelId = $_GET['modelId'];
        $modelId = mysqli_real_escape_string($con, $modelId);

        $client_role = $_GET['client_role'];
        $client_role = mysqli_real_escape_string($con, $client_role);

        $client_balance = $_GET['client_balance'];
        $client_balance = mysqli_real_escape_string($con, $client_balance);

        //check if username exist
        $check = "SELECT `user_name` FROM `users` WHERE `user_name` = '$username'";
        $checkR = mysqli_num_rows(mysqli_query($con, $check));

        if ($checkR > 0) {
            http_response_code(422);
        } else {

            //proceed if username is not registered yet
            $sql = "insert into users(`full_name`,`user_name`,`user_pass`,`user_encryptedPass`,`user_duration`,`user_upline`,`user_rank`, `user_credits`, `model_id`, `whmcs_account`) 
            values('$username','$username','$password','$auth_pass','0','1','reseller', '$client_balance', '$modelId', 1)";

            if (mysqli_query($con, $sql)) {
                echo "success";
                http_response_code(201);

            } else {
                http_response_code(422);
            }

        }

    }
    else {
        $username = $_GET['username'];
        $username = mysqli_real_escape_string($con, $username);

        $password = $_GET['password'];
        $password = mysqli_real_escape_string($con, $password);

        $auth_pass = md5($password);

        $modelId = $_GET['modelId'];
        $modelId = mysqli_real_escape_string($con, $modelId);

        $validity = $_GET['duration'];
        $validity = mysqli_real_escape_string($con, $validity);


        if ($validity == 1) {
            $user_credits = 1;
            $duration = 43200;
        } elseif ($validity == 999) {
            $user_credits = 0;
            $duration = 120;
        }


        $date = date("Y-m-d h:i:s");
        $expired_on = date("Y-m-d h:i:s", strtotime("+$duration months", strtotime($date)));

        //check if username exist
        $check = "SELECT user_name FROM `users` WHERE `user_name` = '$username'";
        $checkR = mysqli_num_rows(mysqli_query($con, $check));

        if ($checkR > 0) {
            http_response_code(422);

        } else {

            //proceed if username is not registered yet
            $query = "insert into users(`full_name`,`user_name`,`user_pass`,`user_encryptedPass`,`user_duration`,`user_upline`,`user_rank`, `model_id`, `whmcs_account`) 
            values('whmcs','$username','$password','$auth_pass','$duration','1','normal', '$modelId', 1)";

            if (mysqli_query($con, $query)) {
                echo "success";
                http_response_code(200);

            } else {
                http_response_code(422);
            }
        }
    }
}

if (isset($_GET['renew'])) {

    $modelId = $_GET['modelId'];
    $modelId = mysqli_real_escape_string($con, $modelId);

    $validity = $_GET['duration'];
    $validity = mysqli_real_escape_string($con, $validity);
    $duration = (($validity * 30) * 24) * 60;
    $date = date("Y-m-d h:i:s");
    $sql = "UPDATE `users` SET `user_duration` = `user_duration` + $duration WHERE `model_id` = $modelId";

    $result = mysqli_query($con, $sql);
    if ($result) {
        echo "success";
        http_response_code(200);
    } else {
        http_response_code(422);
    }

}

if (isset($_GET['terminate'])) {

    $modelId = $_GET['modelId'];
    $modelId = mysqli_real_escape_string($con, $modelId);

    $info = "SELECT id FROM vpns WHERE `model_id` = '$modelId'";

    $infoR = mysqli_query($con, $info);
    $id = mysqli_fetch_assoc($infoR)['id'];

    $sql = "UPDATE `users` SET `is_freeze` = 1 WHERE `model_id` = '$modelId'";

    if (mysqli_query($con, $sql)) {
        echo "success";
        http_response_code(200);
    } else {
        http_response_code(422);
    }

}

if (isset($_GET['suspend'])) {

    $modelId = $_GET['modelId'];
    $modelId = mysqli_real_escape_string($con, $modelId);

    $info = "SELECT id FROM vpns WHERE `model_id` = '$modelId'";

    $infoR = mysqli_query($con, $info);
    $id = mysqli_fetch_assoc($infoR)['id'];

    $sql = "UPDATE `users` SET `is_freeze` = 1 WHERE `model_id` = '$modelId'";

    if (mysqli_query($con, $sql)) {
        echo "success";
        http_response_code(200);
    } else {
        http_response_code(422);
    }

}

if (isset($_GET['unsuspend'])) {

    $modelId = $_GET['modelId'];
    $modelId = mysqli_real_escape_string($con, $modelId);

    $info = "SELECT id FROM vpns WHERE `model_id` = '$modelId'";

    $infoR = mysqli_query($con, $info);
    $id = mysqli_fetch_assoc($infoR)['id'];

    $sql = "UPDATE `users` SET `is_freeze` = 0 WHERE `model_id` = '$modelId'";

    if (mysqli_query($con, $sql)) {
        echo "success";
        http_response_code(200);
    } else {
        http_response_code(422);
    }

}

if (isset($_GET ['changePwd'])) {
    $password = $_GET['password'];
    $password = mysqli_real_escape_string($con, $password);
    $auth_pass = md5($password);

    if ($_GET['changePwd'] === 'reseller') {
        $modelId = $_GET['modelId'];
        $modelId = mysqli_real_escape_string($con, $modelId);

    } else {
        $modelId = $_GET['modelId'];
        $modelId = mysqli_real_escape_string($con, $modelId);
    }

    $sql = "UPDATE users SET `user_pass` = '$password', `user_encryptedPass` = '$auth_pass' WHERE `model_id` = '$modelId'";
    $result = mysqli_query($con, $sql);
    if (mysqli_num_rows($result) > 0) {
        echo "success";
        http_response_code(201);
    } else {
        http_response_code(422);
    }
}

if(isset($_GET['getCredits'])){

    $modelId = $_GET['modelId'];
    $sql = "SELECT `user_credits` FROM `users` WHERE `model_id` = '$modelId'";
    $result = mysqli_query($con, $sql);
    $credits = mysqli_fetch_assoc($result);
    echo $credits['user_credits'];


}

